# 페이징 & 세그먼테이션(PDF)
다중 프로그래밍 시스템에 여러 프로세스를 수용하기 위해 주 기억 장치를 동적 분할하는 메모리 관리 작업이 필요하다.  

## 메모리 할당(Memory Allocation)
운영체제가 새 프로세스를 실행시키거나 실행중인 프로세스가 메모리를 필요로 할 때 물리 메모리를 할당하는 것이다. 메모리 할당은 운영체제 커널에 의해 이루어진다.  

### 연속 메모리 할당(Contiguous Memory Allocation)
- 프로세스에 1개의 연속된 메모리 블록을 할당하는 기법이다.
- 초기 운영체제에서 사용하였지만 지금은 거의 사용하지 않는다.
- 프로세스를 메모리에 담기 위해 메모리는 미리 공간을 분할해두는데, 두 가지 방식이 존재한다.
  - **고정 크기 할당** : 프로세스마다 메모리 전체를 고정된 크기로 분할한 파티션을 할당한다. `내부 단편화`가 발생한다.
  - **가변 크기 할당** : 프로세스마다 프로세스의 크기의 파티션을 할당한다. `외부 단편화`가 발생한다.
- 프로세스에 하나의 연속된 메모리를 할당하므로 메모리 할당의 유연성이 부족하다.

<br>

### 분할 메모리 할당(Non-contiguous Memory Allocation)
- 연속 메모리 할당과 달리 메모리를 여러 개로 분할하여 분산 할당한다.
- 단편화로 인한 메모리 낭비를 줄이기 위해 고안된 방법이다.
- 다음은 대표적인 2가지 방법이다.
  - **고정 크기 할당** : `페이징`
  - **가변 크기 할당** : `세그멘테이션`

<br>


## 단편화(Fragmentation)
- 프로세스에게 할당할 수 없는 작은 크기의 `홀(hole, 조각 메모리)`이 생기는 현상이다.
- 프로세스들이 메모리에 적재되고 제거되는 일이 반복되면, 프로세스들이 차지하는 메모리 틈 사이사이에 빈 공간들이 늘어나서 발생한다.
- 홀이 생기는 위치에 따라 `내부 단편화`와 `외부 단편화`로 나뉜다.

<br>

### 내부 단편화 (Internal Fragmentation)
- 프로세스에게 할당된 메모리 영역 내에 활용할 수 없는 홀이 생기는 경우이다.
- 프로세스가 요청한 양보다 더 많은 메모리를 할당할 때 발생한다.
- `고정 크기 할당`에서 볼 수 있다.  
<img width="600" src = "https://user-images.githubusercontent.com/102718303/210676423-bb09a5c8-8d20-4820-a210-69e821adf060.png">

<br>

### 외부 단편화 (External Fragmentation)
- 할당된 메모리 사이에 활용할 수 없는 홀이 생기는 경우이다.
- 메모리의 할당 & 해제의 반복으로 크기가 다른 파티션이 할당되고 반환되기를 반복하면서 파티션 사이 홀이 생겨서 발생한다.
- 프로세스가 사용하는 공간을 한쪽으로 몰아서 공간을 확보하는 `메모리 압축(memory compaction)`을 사용하면 해결 가능하지만, 효율성이 떨어진다.  
<img width="600" src = "https://user-images.githubusercontent.com/102718303/210676654-bf1aa192-243e-4142-899a-4c4856fdb46b.png">

<br>

## 페이징(Paging)
프로세스를 일정한 크기의 페이지\*로 분할하여 메모리의 프레임\*에 하나씩 분산 할당한다.  

_\*페이지 : 일정 사이즈의 가상 메모리 내 프로세스 조각_  
_\*프레임 : 페이지와 동일한 크기로 분할한 메모리 조각_  

<br>

### 페이징 테이블 (Paging Table)
- 모든 프로세스는 하나의 페이징 테이블을 가지고 있다.
- 페이징 테이블에는 `각 페이지 번호`와 그 페이지가 위치하는 `프레임의 시작 주소`가 있다.
- 페이징 테이블을 통해 가상 메모리 상의 페이지들이 물리 메모리의 어디 프레임에 적재되어 있는지 알 수 있다.

<img width="600" src="https://img1.daumcdn.net/thumb/R1280x0/?scode=mtistory2&fname=https%3A%2F%2Fblog.kakaocdn.net%2Fdn%2FlUpSH%2FbtrfV9pcZrh%2FWtBruLdUe5uDYa2zpET6uK%2Fimg.png">

- **장점**
  - 연속되어 저장되지 않기 때문에 외부 단편화가 생기지 않는다.
  - 할당과 해제가 빠르다
  - [swap out](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/메모리%20관리.md)이 간단하다.
- **단점**
  - 프로세스의 최대 크기에 맞추어 생산되지만, 실제 프로세스의 크기는 그에 못 미치기 때문에 내부 단편화 문제가 발생할 수 있다. 페이지 단위가 작으면 해결할 수 있지만 매핑이 복잡해진다.
  - page table을 위한 메모리가 추가로 소모된다.
  - page table이 메모리에 있기 때문에 접근하는 연산은 2번의 메모리 접근이 필요하게 되어 속도가 느리다.
    - 속도 향상을 위해 [TLB](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/메모리%20관리.md)를 사용한다.
  
</br>


## 세그멘테이션(Segmentation)
- 프로세스를 구성하는 세그먼트\*들을 동일한 크기로 분할하여 메모리에 분산 할당한다.
- 일반적으로 프로세스를 `code`, `data`, `stack`, `heap` 4개의 세그먼트로 분할하고 할당한다.

<br>

_\*세그먼트 : 프로세스 내에서 하나의 단위로 다룰 수 있는 블록으로, 가상 메모리를 서로 크기가 다른 논리적 단위로 분할한 것_  

<br>

### 세그먼트 테이블(Segment Table)
- 프로세스 당 세그먼트의 개수가 작기 때문에 시스템 전체에 1개의 세그먼트 테이블을 이용하여 적재된 모든 프로세스들의 세그먼트들을 관리한다.
- 세그먼트 테이블에는 `세그먼트 크기`와 `세그먼트 시작 주소`가 있다.
- **장점**  
프로세스가 필요한 만큼 할당해주기 때문에 내부 단편화가 발생하지 않는다. 
- **단점**  
프로세스가 실행되고 해제되는 과정이 반복되면 세그먼트들 사이에 홀아 생기며, 작은 홀들로 인해 `외부 단편화`가 초래된다.

<br>

## 페이징 vs 세그멘테이션
페이징이 세그멘테이션보다 여러 면에서 우수하다. 
* 세그멘테이션에서 발생하는 외부 단편화가 없고, 메모리 활용과 시간 오버헤드 면에서 훨씬 우수하다. 내부 단편화가 발생하지만, 그 크기가 매우 작다.
* 메모리를 고정 크기의 페이지로 분할하기 때문에 세그멘테이션보다 구현이 쉽다.
* CPU에 의존적이지 않아 높은 이식성을 갖는다.
* 시스템에 따라 페이지의 크기를 달리 설정 할 수 있어 융통성이 높다.

----

## Reference
- https://steady-coding.tistory.com/524
- https://kyoun.tistory.com/31
- 명품 운영체제, 황기태 저, 생능출판사, 2023 




